.ifndef __VBLANK_HANDLER_ASM__
.define __VBLANK_HANDLER_ASM__

.bank 0 slot 0


;output the memory palette buffer to VRam
; c : VdpDataPort
.macro outputPalette ;Lbl_d0f5
	xor a
	out (VdpControlPort), a
	ld a, CramWrite.hi
	out (VdpControlPort), a

	fastOtir 32
.endm

;output the memory sprite table to VRam
; c : VdpDataPort
.macro outputSpriteTable
	xor a
	out (VdpControlPort), a
	ld a, VramWrite.hi | VramSpriteTable.hi
	out (VdpControlPort), a
	
	ld hl, spriteTable
	fastOtir 64
	
	ld a, VramSpriteTableBottom.lo
	out (VdpControlPort), a
	ld a, VramWrite.hi | VramSpriteTable.hi
	out (VdpControlPort), a
	
	fastOtir 128
.endm

;generates a new random values
; c : VdpDataPort
.macro updateRandomValue 
	ld a, r
	ld b, a
	rla
	ld c, a
	ld a, (frameCounter)
	rlca
	rlca
	rlca
	rlca
	xor c
	ld (random), a
.endm


;output raw data to the Vdp
;hl : vramRaw.destination
; c : VdpControlPort
.section "outputRawData" free
outputRawData:
	outi
	outi
	dec c ;ld c, VdpDataPort
	ld e, (hl)
	inc l
	ld d, (hl)
	inc l
	jumpDe
.ends

;output a column to de VdpNameTable
; c : VdpDataPort
.section "outputColumn" free
outputColumn:
	ld b, VramRowCount*2
	ld de, (64 << 8) | (>VramWrite | $38)
	ld a, (hl)
	rlca
	inc l
-:		.rept 3 
			inc c
			out (VdpControlPort), a
			out (c), e
			add a, d
			dec c
			outi
			outi
		.endr
		inc c
		out (VdpControlPort), a
		out (c), e
		add a, d
		inc e
		dec c
		outi
		outi
	jp nz, -
	ret
.ends


;original : Lbl_cff0
.section "vBlankHandler" free
vBlankHandler:
	exx
	ex af, af'
	in a, (VdpStatusPort)
	ld a, (waitingForVBlank)
	or a
	jr z, runSoundEngine
		ld c, VdpDataPort
		xor a
		ld (waitingForVBlank), a
		outputSpriteTable
		
		ld hl, palette.hasNewPalette
		ld a, (hl)
		dec a
		jp nz, +
			ld (hl), a
			inc l
			outputPalette
;check if there's a new stream of raw data to output	
+: 		ld hl, vramRaw.haveData
		ld a, (hl)
		dec a
		jp nz, +
			ld (hl), a
			inc l
			inc c ; ld vdpControlPort
			call outputRawData
;check if there's a new column to output
+:		ld hl, column.hasNewColumn
		ld a, (hl)
		dec a
		jp nz, +
			ld (hl), a
			inc l
			call outputColumn
;update scrolls
+:		inc c ; ld vdpControlPort
		ld hl, horizontalScroll + 1
		ld de, (VdpVerticalScroll << 8) | VdpHorizontalScroll
		outi
		out (c), e
		inc l
		outi
		out (c), d
;increment frame counter		
		ld hl, frameCounter
		inc (hl)	
;update misc registers of the Vdp		
		ld a, (vdpMisc2Value)
		or M2DisplayEnabled
		ld (vdpMisc2Value), a 
		out (VdpControlPort), a
		ld a, VdpMisc2
		out (VdpControlPort), a
	

runSoundEngine: ;Lbl_d08d:
	ld a, (MapperSlot2Read)
	push af
	ld a, PSGBank
	ld (MapperSlot2), a
	call PSGFrame
	pop af
	ld (MapperSlot2), a

	updateRandomValue
	exx
	ex af, af'
	ei
	ret 
.ends


;start waiting for vBlank. After the interrupt handler finishes, read the control ports.
.section "prepareForVblank" free
prepareForVblank: ; Lbl_c0ab
	ld a, $01
	ld hl, waitingForVBlank
	ld (hl), a
-:	and (hl)
	jp nz, -
	
	ld hl, (readControlsFunction)
	jp (hl)
endControlReading:	
	ld hl, holdedKeys
	ld b, a
	ld a, (hl)
	ld (hl), b
	inc l ; ld hl, holdedKeysPrevious
	ld (hl), a
	inc l ; ld hl, pressedKeys
	xor b
	and b
	ld (hl), a
	ret 
.ends

.endif